<?php
/**
 * Enable theme features
 */
add_theme_support('root-relative-urls');    // Enable relative URLs
add_theme_support('bootstrap-top-navbar');  // Enable Bootstrap's top navbar
add_theme_support('bootstrap-gallery');     // Enable Bootstrap's thumbnails component on [gallery]
add_theme_support('nice-search');           // Enable /?s= to /search/ redirect
add_theme_support('automatic-feed-links');

/**
 * Configuration values
 */
define( 'POST_EXCERPT_LENGTH', 20); // Length in words for excerpt_length filter (http://codex.wordpress.org/Plugin_API/Filter_Reference/excerpt_length)

/**
 * .main classes
 */
function wedocs_main_class() {
    if ( wedocs_display_sidebar() ) {
        // Classes on pages with the sidebar
        $class = 'col-sm-8';
    } else {
        // Classes on full width pages
        $class = 'col-sm-12';
    }

    return $class;
}

/**
 * .sidebar classes
 */
function wedocs_sidebar_class() {
    return 'col-sm-4';
}

/**
 * Define which pages shouldn't have the sidebar
 *
 * See lib/sidebar.php for more details
 */
function wedocs_display_sidebar() {
    $sidebar_config = new Roots_Sidebar(
        /**
         * Conditional tag checks (http://codex.wordpress.org/Conditional_Tags)
         * Any of these conditional tags that return true won't show the sidebar
         *
         * To use a function that accepts arguments, use the following format:
         *
         * array('function_name', array('arg1', 'arg2'))
         *
         * The second element must be an array even if there's only 1 argument.
         */
        array(
            'is_404',
            'is_front_page',
            'is_archive',
            'is_single',
            'is_search',
        ),
        /**
         * Page template checks (via is_page_template())
         * Any of these page templates that return true won't show the sidebar
         */
        array(
            'template-custom.php',
            'templates/full-width.php'
        )
    );
    return apply_filters('wedocs_display_sidebar', $sidebar_config->display);
}

/**
 * $content_width is a global variable used by WordPress for max image upload sizes
 * and media embeds (in pixels).
 *
 * Example: If the content area is 640px wide, set $content_width = 620; so images and videos will not overflow.
 * Default: 1140px is the default Bootstrap container width.
 */
if ( !isset( $content_width ) ) {
    $content_width = 835;
}
